import sys
import os
import re

def modify_fontsize(file_path):
    try:
        # Read the file content
        with open(file_path, 'r', encoding='utf-8') as file:
            content = file.read()

        # Replace specific fonts with $Debug_REG
        content = re.sub(r'<Font>\$(body1|body2|body|title1|title2|title|FixedWidthNumbers)</Font>', r'<Font>$Debug_REG</Font>', content)

        # Function to modify the FontSize value only if it follows $Debug_REG
        def modify_match(match):
            font_tag, fontsize_tag = match.groups()
            if "$Debug_REG" in font_tag:
                value = int(re.search(r'value="(\d+)"', fontsize_tag).group(1))
                return f"{font_tag}\n<FontSize value=\"{value + 40}\" />"
            return match.group(0)

        # Regex pattern to find the target font and its associated FontSize
        pattern = r'(<Font>\$.*?</Font>)\s*(<FontSize value=\"\d+\"\s?/?>)'
        modified_content = re.sub(pattern, modify_match, content)

        # Convert line endings to Unix style
        modified_content = modified_content.replace('\r\n', '\n').replace('\r', '\n')

        # Rename the original file with a .bak extension
        backup_file_path = f"{file_path}.bak"
        os.rename(file_path, backup_file_path)

        # Save the modified content back to the original file
        with open(file_path, 'w', encoding='utf-8', newline='\n') as file:
            file.write(modified_content)

        print(f"Original file backed up as: {backup_file_path}")
        print(f"Modified file saved as: {file_path}")
    except Exception as e:
        print(f"Error processing {file_path}: {e}")

if __name__ == "__main__":
    if len(sys.argv) > 1:
        for file_path in sys.argv[1:]:
            if os.path.isfile(file_path):
                modify_fontsize(file_path)
            else:
                print(f"Skipped: {file_path} is not a valid file.")
    else:
        print("Drag and drop files onto this script to process them.")
